/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.common.CompositeDocumentProvider;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.php.core.IPHPVersionListener;
import com.aptana.editor.php.internal.ui.editor.PHPPartitionerSwitchStrategy;
import com.aptana.editor.php.internal.ui.editor.PHPSourceConfiguration;
import com.aptana.editor.php.internal.ui.editor.PHPVersionDocumentManager;
import com.aptana.editor.php.internal.ui.editor.SourceModuleAnnotationModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPDocumentProvider
extends CompositeDocumentProvider
implements IPHPVersionListener {
    private PHPVersion phpVersion;
    private IDocument document;

    public PHPDocumentProvider() {
        super("com.aptana.contenttype.phtml.php", (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault(), (IPartitioningConfiguration)PHPSourceConfiguration.getDefault(), (IPartitionerSwitchStrategy)PHPPartitionerSwitchStrategy.getDefault());
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        this.document = this.getDocument(element);
        PHPVersionDocumentManager.increaseDocumentCount(this.document);
        if (this.phpVersion != null) {
            PHPVersionDocumentManager.updateVersion(this.document, this.phpVersion);
        }
    }

    public void disconnect(Object element) {
        PHPVersionDocumentManager.decreaseDocumentCount(this.document);
        super.disconnect(element);
    }

    @Override
    public void phpVersionChanged(PHPVersion newVersion) {
        this.phpVersion = newVersion;
        if (this.document != null && newVersion != null) {
            PHPVersionDocumentManager.updateVersion(this.document, this.phpVersion);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new SourceModuleAnnotationModel((IResource)file);
    }
}

